<?php

$hudson_edge_icon_collections = hudson_edge_return_icon_collections();
//Masonry Gallery Metaboxes

//General settings for text, buttons, links
$edgtMasonryGalleryItemGeneral = new HudsonEdgeMetaBox(
	"masonry_gallery",
	esc_html__( "Masonry Gallery General", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"masonry_gallery_item_general",
	$edgtMasonryGalleryItemGeneral
);

$edgt_masonry_gallery_item_text = new HudsonEdgeMetaField(
	'text',
	'edgt_masonry_gallery_item_text',
	'',
	esc_html__( 'Text', 'hudson' ),
	''
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_text',
	$edgt_masonry_gallery_item_text
);

$edgt_masonry_gallery_item_link = new HudsonEdgeMetaField(
	'text',
	'edgt_masonry_gallery_item_link',
	'',
	esc_html__( 'Link', 'hudson' ),
	''
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_link',
	$edgt_masonry_gallery_item_link
);

$edgt_masonry_gallery_item_link_target = new HudsonEdgeMetaField(
	'select',
	'edgt_masonry_gallery_item_link_target',
	'_self',
	esc_html__( 'Link target', 'hudson' ),
	'',
	array(
		'_self'  => 'Self',
		'_blank' => 'Blank'
	)
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_link_target',
	$edgt_masonry_gallery_item_link_target
);

$edgt_masonry_item_parallax = new HudsonEdgeMetaField(
	"select",
	"edgt_masonry_item_parallax",
	"no",
	esc_html__( "Set Item in Parallax", 'hudson' ),
	"",
	array(
		"no"  => "No",
		"yes" => "Yes"
	)
);
$edgtMasonryGalleryItemGeneral->addChild(
	"edgt_masonry_item_parallax",
	$edgt_masonry_item_parallax
);

//Masonry Gallery Style - Size, Type
$section_style_title = new HudsonEdgeTitle(
	'section_style_title',
	esc_html__( 'Masonry Gallery Item Style', 'hudson' )
);
$edgtMasonryGalleryItemGeneral->addChild(
	'section_style_title',
	$section_style_title
);

$edgt_masonry_gallery_item_size = new HudsonEdgeMetaField(
	'select',
	'edgt_masonry_gallery_item_size',
	'square_small',
	esc_html__( 'Size', 'hudson' ),
	'size',
	array(
		'square_small' => esc_html__( 'Square Small', 'hudson' ),
		'square_big' => esc_html__( 'Square Big', 'hudson' ),
		'rectangle_portrait' => esc_html__( 'Rectangle Portrait', 'hudson' ),
		'rectangle_landscape' => esc_html__( 'Rectangle Landscape', 'hudson' )
	)
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_size',
	$edgt_masonry_gallery_item_size
);

$edgt_masonry_gallery_item_type = new HudsonEdgeMetaField(
	'select',
	'edgt_masonry_gallery_item_type',
	'with_button',
	esc_html__( 'Type', 'hudson' ),
	'type',
	array(
		'with_button' => esc_html__( 'With Button', 'hudson' ),
		'with_icon' => esc_html__( 'With Icon', 'hudson' ),
		'standard' => esc_html__( 'Standard', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			'with_button' => '#edgtf_edgt_masonry_gallery_item_icon_type_container',
			'with_icon'   => '#edgtf_edgt_masonry_gallery_item_button_type_container',
			'standard'    => '#edgtf_edgt_masonry_gallery_item_button_type_container, #edgtf_edgt_masonry_gallery_item_icon_type_container'
		),
		'show'       => array(
			'with_button' => '#edgtf_edgt_masonry_gallery_item_button_type_container',
			'with_icon'   => '#edgtf_edgt_masonry_gallery_item_icon_type_container',
			'standard'    => ''
		)
	)
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_type',
	$edgt_masonry_gallery_item_type
);

$edgt_masonry_gallery_item_button_type_container = new HudsonEdgeContainer(
	'edgt_masonry_gallery_item_button_type_container',
	'edgt_masonry_gallery_item_type',
	'',
	array( 'standard', 'with_icon' )
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_button_type_container',
	$edgt_masonry_gallery_item_button_type_container
);

$edgt_masonry_gallery_button_label = new HudsonEdgeMetaField(
	'text',
	'edgt_masonry_gallery_button_label',
	'',
	esc_html__( 'Button Label', 'hudson' ),
	''
);
$edgt_masonry_gallery_item_button_type_container->addChild(
	'edgt_masonry_gallery_button_label',
	$edgt_masonry_gallery_button_label
);
//Icon Packages
$edgt_masonry_gallery_item_button_icon_hide_array = array();
$edgt_masonry_gallery_item_button_icon_show_array = array();

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	$edgt_masonry_gallery_item_icon_collection_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		
		$edgt_masonry_gallery_item_button_icon_hide_array[ $dep_collection_key ] = '';
		
		$edgt_masonry_gallery_item_button_icon_show_array[ $dep_collection_key ] = '#edgtf_edgt_masonry_gallery_item_with_button_' . $dep_collection_object->param . '_container';
		
		foreach ( $edgt_masonry_gallery_item_icon_collection_params as $edgt_masonry_gallery_item_icon_collection_param ) {
			
			if ( $edgt_masonry_gallery_item_icon_collection_param !== $dep_collection_object->param ) {
				$edgt_masonry_gallery_item_button_icon_hide_array[ $dep_collection_key ] .= '#edgtf_edgt_masonry_gallery_item_with_button_' . $edgt_masonry_gallery_item_icon_collection_param . '_container,';
			}
			
		}
		
		$edgt_masonry_gallery_item_button_icon_hide_array[ $dep_collection_key ] = rtrim(
			$edgt_masonry_gallery_item_button_icon_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$edgt_masonry_gallery_item_with_button_icon_pack = new HudsonEdgeMetaField(
	'select',
	'edgt_masonry_gallery_item_with_button_icon_pack',
	'font_awesome',
	esc_html__( 'Button Icon Package', 'hudson' ),
	esc_html__( 'Choose Icon Package', 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		'dependence' => true,
		'hide'       => $edgt_masonry_gallery_item_button_icon_hide_array,
		'show'       => $edgt_masonry_gallery_item_button_icon_show_array
	)
);
$edgt_masonry_gallery_item_button_type_container->addChild(
	'edgt_masonry_gallery_item_with_button_icon_pack',
	$edgt_masonry_gallery_item_with_button_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$edgt_masonry_gallery_item_icon_hide_values = $icon_collections_keys;
		
		$edgt_masonry_gallery_item_icon_pack_container = new HudsonEdgeContainer(
			'edgt_masonry_gallery_item_with_button_' . $collection_object->param . '_container',
			'edgt_masonry_gallery_item_with_button_icon_pack',
			'',
			$edgt_masonry_gallery_item_icon_hide_values
		);
		$edgt_masonry_gallery_item_button_type_container->addChild(
			'edgt_masonry_gallery_item_with_button_' . $collection_object->param . '_container',
			$edgt_masonry_gallery_item_icon_pack_container
		);
		
		$edgt_masonry_gallery_item_with_icon_icon_type = new HudsonEdgeMetaField(
			'select',
			'edgt_masonry_gallery_item_with_button_' . $collection_object->param,
			'',
			$collection_object->title,
			esc_html__( 'Icon Package', 'hudson' ),
			$icons_array
		);
		$edgt_masonry_gallery_item_icon_pack_container->addChild(
			'edgt_masonry_gallery_item_with_button_' . $collection_object->param,
			$edgt_masonry_gallery_item_with_icon_icon_type
		);
		
	}
	
}

$edgt_masonry_gallery_item_icon_type_container = new HudsonEdgeContainer(
	'edgt_masonry_gallery_item_icon_type_container',
	'edgt_masonry_gallery_item_type',
	'',
	array( 'standard', 'with_button' )
);
$edgtMasonryGalleryItemGeneral->addChild(
	'edgt_masonry_gallery_item_icon_type_container',
	$edgt_masonry_gallery_item_icon_type_container
);
//Icon Packages
$edgt_masonry_gallery_item_icon_hide_array = array();
$edgt_masonry_gallery_item_icon_show_array = array();

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	$edgt_masonry_gallery_item_icon_collection_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		
		$edgt_masonry_gallery_item_icon_hide_array[ $dep_collection_key ] = '';
		
		$edgt_masonry_gallery_item_icon_show_array[ $dep_collection_key ] = '#edgtf_edgt_masonry_gallery_item_with_icon_' . $dep_collection_object->param . '_container';
		
		foreach ( $edgt_masonry_gallery_item_icon_collection_params as $edgt_masonry_gallery_item_icon_collection_param ) {
			
			if ( $edgt_masonry_gallery_item_icon_collection_param !== $dep_collection_object->param ) {
				$edgt_masonry_gallery_item_icon_hide_array[ $dep_collection_key ] .= '#edgtf_edgt_masonry_gallery_item_with_icon_' . $edgt_masonry_gallery_item_icon_collection_param . '_container,';
			}
			
		}
		
		$edgt_masonry_gallery_item_icon_hide_array[ $dep_collection_key ] = rtrim(
			$edgt_masonry_gallery_item_icon_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$edgt_masonry_gallery_item_with_icon_icon_pack = new HudsonEdgeMetaField(
	'select',
	'edgt_masonry_gallery_item_with_icon_icon_pack',
	'font_awesome',
	esc_html__( 'Icon Package', 'hudson' ),
	esc_html__( 'Choose Icon Package', 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		'dependence' => true,
		'hide'       => $edgt_masonry_gallery_item_icon_hide_array,
		'show'       => $edgt_masonry_gallery_item_icon_show_array
	)
);
$edgt_masonry_gallery_item_icon_type_container->addChild(
	'edgt_masonry_gallery_item_with_icon_icon_pack',
	$edgt_masonry_gallery_item_with_icon_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$edgt_masonry_gallery_item_icon_hide_values = $icon_collections_keys;
		
		$edgt_masonry_gallery_item_icon_pack_container = new HudsonEdgeContainer(
			'edgt_masonry_gallery_item_with_icon_' . $collection_object->param . '_container',
			'edgt_masonry_gallery_item_with_icon_icon_pack',
			'',
			$edgt_masonry_gallery_item_icon_hide_values
		);
		$edgt_masonry_gallery_item_icon_type_container->addChild(
			'edgt_masonry_gallery_item_with_icon_' . $collection_object->param . '_container',
			$edgt_masonry_gallery_item_icon_pack_container
		);
		
		$edgt_masonry_gallery_item_with_icon_icon_type = new HudsonEdgeMetaField(
			'select',
			'edgt_masonry_gallery_item_with_icon_' . $collection_object->param,
			'',
			$collection_object->title,
			esc_html__( 'Icon Package', 'hudson' ),
			$icons_array
		);
		$edgt_masonry_gallery_item_icon_pack_container->addChild(
			'edgt_masonry_gallery_item_with_icon_' . $collection_object->param,
			$edgt_masonry_gallery_item_with_icon_icon_type
		);
		
	}
	
}